<?xml version="1.0" encoding="iso-8859-1"?>


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:svg="http://www.svg.com/2000/svg"
                              xmlns:xlink="http://xlink.org"
                              xmlns:ms="urn:schemas-microsoft-com:xslt"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:usr="urn:the-xml-files:xslt">

<!-- <xsl:output method="xml" media-type="image/svg+xml" indent="yes" /> -->



<xsl:param name="tablename"    select="/report/table[1]/tablename"/>
<xsl:param name="default"      select="'default'"/>
<xsl:param name="xmlfile"      select="/report/xmlfile"/>
<xsl:param name="mode"         select="'text'"/>

<xsl:param name="comp">
    <xsl:choose>
      <xsl:when test="/report/table[tablename=$tablename]/comparison"><xsl:value-of  select="/report/table[tablename=$tablename]/comparison"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="key('table', 'default')/comparison"/></xsl:otherwise>
     </xsl:choose>
</xsl:param>

<xsl:param name="comparison">
     <xsl:choose>
        <xsl:when test="$comp!=''"><xsl:value-of select="$comp"/></xsl:when>
        <xsl:otherwise>percent</xsl:otherwise>
     </xsl:choose>
</xsl:param>

<xsl:param name="regioncode"   select="/report/countries/country[1]/key"/>
<xsl:param name="yearcode"     select="/report/years/year[1]/key"/>
<xsl:param name="scenariocode" select="/report/scenarios/scenario[1]/key"/>
<xsl:param name="productcode"  select="/report/products/product[1]/key"/>
<xsl:param name="itemcode"     select="/report/items[@table=$tablename]/item[1]/name"/>

<xsl:key name="region"    match="country"    use="key"/>
<xsl:key name="year"      match="year"       use="key"/>
<xsl:key name="scenario"  match="scenario"   use="key"/>
<xsl:key name="product"   match="product"    use="key"/>
<xsl:key name="activity"  match="activity"   use="key"/>
<xsl:key name="item"      match="item"       use="key"/>
<xsl:key name="report"    match="report"     use="countries"/>


<!-- globale Parameter, die von die fr den javascript aufruf bentigt werden; sie sind vorbesetzt mit -->
<!-- den Werten fr die Tabelle bzw. die Region, die beim ersten Aufruf angezeigt werden.              -->


<!-- drei Keys zum Auffinden von Knoten anhand ihres Inhaltes                  -->
<!-- Finden der verschiedenen Tabellenaufbauten anhand ihres Namens            -->
<xsl:key name="table"   match="table"       use="tablename"/>

<!-- Finden des Products bzw. der activity in der Datentabelle anhand des keys -->
<xsl:key name="Product" match="rows"        use="name"/>

<!-- setzen der Variablen, die angeben, welche Datenelemente wie und wo in der Tabelle auftauchen -->

  <xsl:variable name="column">
    <xsl:choose>
      <xsl:when test="key('table', $tablename)/columns"><xsl:value-of select="key('table', $tablename)/columns"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="key('table', 'default')/columns"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="row">
    <xsl:choose>
      <xsl:when test="key('table', $tablename)/rows"><xsl:value-of  select="key('table', $tablename)/rows"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="key('table', 'default')/rows"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="innercolumn">
    <xsl:choose>
      <xsl:when test="key('table', $tablename)/innercolumns"><xsl:value-of  select="key('table', $tablename)/innercolumns"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="key('table', 'default')/innercolumns"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="innerrow">
    <xsl:choose>
      <xsl:when test="key('table', $tablename)/innerrows"><xsl:value-of  select="key('table', $tablename)/innerrows"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="key('table', 'default')/innerrows"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="activity">
     <xsl:choose>
        <xsl:when test="/report/table[tablename=$tablename]/activity='yes'">yes</xsl:when>
        <xsl:otherwise>no</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>


  <xsl:variable name="links">
    <xsl:choose>
      <xsl:when test="/report/table[tablename=$tablename]/links"><xsl:value-of  select="/report/table[tablename=$tablename]/links"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="key('table', 'default')/links"/></xsl:otherwise>
     </xsl:choose>
  </xsl:variable>
  <xsl:variable name="setLinks">
     <xsl:choose>
        <xsl:when test="$links!=''"><xsl:value-of select="$links"/></xsl:when>
        <xsl:otherwise>yes</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>



  <xsl:variable name="basescen" select="/report/scenarios/scenario[@base='yes']/key"/>


  <xsl:variable name="regionSel"     select="/report/countries/country[   (contains(name/@sel,'all') and concat(key('table',$tablename)/countries/@sel,'')='' )
                                                                      or  (contains(name/@sel,key('table', $tablename)/countries/@sel) and key('table',$tablename)/countries/@sel!='')]"/>

  <xsl:variable name="yearSel"       select="/report/years/year[ (contains(name/@sel,'all') and concat(key('table',$tablename)/years/@sel,'')='') or
                                                                 (contains(name/@sel,key('table', $tablename)/years/@sel) and key('table',$tablename)/years/@sel!='')]"/>

  <xsl:variable name="scenarioSel"   select="/report/scenarios/scenario[ (contains(name/@sel,'all') and concat(key('table',$tablename)/scenarios/@sel,'')='') or
                                                                         (contains(name/@sel,key('table', $tablename)/scenarios/@sel) and key('table',$tablename)/scenarios/@sel!='')]"/>

  <xsl:variable name="productSel"   select="/report/products/product[ (contains(name/@sel,'all') and concat(key('table',$tablename)/products/@sel,'')='') or
                                                                      (contains(name/@sel,key('table', $tablename)/products/@sel) and key('table',$tablename)/products/@sel!='')]"/>

  <xsl:variable name="activitySel"   select="/report/activities/activity[ (contains(name/@sel,'all') and concat(key('table',$tablename)/activities/@sel,'')='') or
                                                                          (contains(name/@sel,key('table', $tablename)/activities/@sel) and key('table',$tablename)/activities/@sel!='')]"/>




  <xsl:variable name="regionNode">
     <xsl:choose>
     <xsl:when test="count($regionSel[contains(key,$regioncode)])!=0">
       <xsl:value-of select="key('region',$regioncode)/key"/>
     </xsl:when>
     <xsl:otherwise>
       <xsl:value-of select="$regionSel[1]/key"/>
     </xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <xsl:variable name="yearNode">
     <xsl:if test="count($yearSel[contains(key,$yearcode)])!=0">
       <xsl:value-of select="key('year',$yearcode)/key"/>
     </xsl:if>
     <xsl:if test="count($yearSel[contains(key,$yearcode)])=0">
       <xsl:value-of select="$yearSel[1]/key"/>
     </xsl:if>
  </xsl:variable>

  <xsl:variable name="scenarioNode">
     <xsl:if test="count($scenarioSel[contains(key,$scenariocode)])!=0">
       <xsl:value-of select="key('scenario',$scenariocode)/key"/>
     </xsl:if>
     <xsl:if test="count($scenarioSel[contains(key,$scenariocode)])=0">
       <xsl:value-of select="$scenarioSel[1]/key"/>
     </xsl:if>
  </xsl:variable>


  <xsl:variable name="productNode">
     <xsl:if test="$activity!='yes'">
        <xsl:if test="count($productSel[contains(key,$productcode)])!=0">
          <xsl:value-of select="key('product',$productcode)/key"/>
        </xsl:if>
        <xsl:if test="count($productSel[contains(key,$productcode)])=0">
          <xsl:value-of select="$productSel[1]/key"/>
        </xsl:if>
     </xsl:if>
     <xsl:if test="$activity='yes'">
        <xsl:if test="count($activitySel[contains(key,$productcode)])!=0">
          <xsl:value-of select="key('activity',$productcode)/key"/>
        </xsl:if>
        <xsl:if test="count($activitySel[contains(key,$productcode)])=0">
          <xsl:value-of select="$activitySel[1]/key"/>
        </xsl:if>
     </xsl:if>
  </xsl:variable>

  <xsl:variable name="itemNode">
      <xsl:choose>
         <xsl:when test="count(/report/items[@table=$tablename and item/key=$itemcode])=1">
            <xsl:value-of select="key('item',$itemcode)/key"/>
         </xsl:when>
         <xsl:otherwise>
              <xsl:value-of select="/report/items[@table=$tablename]/item[1]/key"/>
         </xsl:otherwise>
      </xsl:choose>
  </xsl:variable>

  <xsl:variable name="rowsel">
     <xsl:choose>
        <xsl:when test="key('table', $tablename)/rows/@sel !=''">
            <xsl:value-of  select="key('table', $tablename)/rows/@sel"/>
        </xsl:when>
        <xsl:otherwise>all</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <xsl:variable name="innerrowsel">
     <xsl:choose>
         <xsl:when test="key('table', $tablename)/innerrows/@sel !=''">
              <xsl:value-of  select="key('table', $tablename)/innerrows/@sel"/>
         </xsl:when>
         <xsl:otherwise>all</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <xsl:variable name="colsel">
     <xsl:choose>
         <xsl:when test="key('table', $tablename)/columns/@sel !=''">
            <xsl:value-of  select="key('table', $tablename)/columns/@sel"/>
         </xsl:when>
         <xsl:otherwise>all</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>

  <xsl:variable name="innercolsel">
     <xsl:choose>
         <xsl:when test="key('table', $tablename)/innercolumns/@sel !=''">
            <xsl:value-of  select="key('table', $tablename)/innercolumns/@sel"/>
         </xsl:when>
         <xsl:otherwise>all</xsl:otherwise>
     </xsl:choose>
  </xsl:variable>


<!-- Setzen der Anfangsknoten der Elemente in scenario.xml anhand der Tabellenvariablen von oben  -->



<xsl:variable name="colNode" select="/report/items[@table=$tablename and $column='items']/* |
                                     /report/scenarios/*[*  and $column='scenarios'] |
                                     /report/products/*[*   and $column='products'     and $activity ='no' ] |
                                     /report/activities/*[*   and $column='activities' and $activity='yes' ] |
                                     /report/countries/*[*  and $column='countries'] |
                                     /report/years/*[*  and $column='years']"/>


<xsl:variable name="innercolNode" select="/report/items[@table=$tablename and $innercolumn='items']/* |
                                          /report/scenarios/*[*  and $innercolumn='scenarios'] |
                                          /report/products/*[*   and $innercolumn='products'   and $activity ='no' ] |
                                          /report/activities/*[*   and $innercolumn='products' and $activity ='yes' ] |
                                          /report/countries/*[*  and $innercolumn='countries'] |
                                          /report/years/*[*  and $innercolumn='years']"/>

<xsl:variable name="rowNode" select="/report/items[@table=$tablename and $row='items']/* |
                                     /report/scenarios/* [*  and $row='scenarios'] |
                                     /report/products/*  [*  and $row='products' and $activity ='no'] |
                                     /report/activities/*[*  and $row='products' and $activity ='yes'] |
                                     /report/countries/* [*  and $row='countries'] |
                                     /report/years/*     [*  and $row='years']"/>

<xsl:variable name="innerrowNode" select="/report/items[@table=$tablename and $innerrow='items']/* |
                                       /report/scenarios/*[*   and $innerrow='scenarios'] |
                                       /report/products/*[*    and $innerrow='products'  and $activity ='no' ] |
                                       /report/activities/*[*  and $innerrow='products'  and $activity ='yes'] |
                                       /report/countries/*[*   and $innerrow='countries'] |
                                       /report/years/*[*   and $innerrow='years']"/>

<xsl:variable name="rownum"        select="count($rowNode/name[contains(@sel,$rowsel)])"/>
<xsl:variable name="colnum"        select="count($colNode/name[contains(@sel,$colsel)])"/>
<xsl:variable name="innercolnum"   select="count($innercolNode/name[contains(@sel,$innercolsel)])"/>
<xsl:variable name="innerrownum"   select="count($innerrowNode/name[contains(@sel,$innerrowsel)])"/>


<xsl:variable name="colWidth"      select="concat(70 div $colnum,'%')"/>
<xsl:variable name="innercolWidth" select="concat(70 div ($colnum*$innercolnum),'%')"/>


<!-- wurzel template mit dem html-body und der javascript funktion             -->
<xsl:template match="/">

<!-- import styles -->
<xsl:copy-of select="document('styles.xsl')"/>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>

   <!--


   <object id="AdobeSVG"
            CLASSID="clsid:78156a80-c6a1-4bbf-8e6a-3cd390eeb4e2">
         </object>
   <xsl:processing-instruction name = "import" >
       namespace="svg" implementation="#AdobeSVG"
   </xsl:processing-instruction>
   -->

</head>


<body bgcolor="#FFFFFF" text="#000000" style="font-family:Arial">

<!-- java script funktion call parser, die das xml jeweils mit den vernderten variablen regioncode,        -->
<!-- tablename parst, so dass verschiedene Ausgaben mit einem Stylesheet mglich werden;                    -->
<!-- zustzlich wird die Variable anker bergeben, die die Ausgabe an der entsprechenden Stell positioniert -->
<SCRIPT language="javascript">
  function call_parser(region, year, scenario, product, item, table, comparison, mode, xmlfile, anchor)
   {// Load XML
         var xml = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
         xml.async = false;
         xml.load(xmlfile);

         // Load the XSL
         var xsl = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
         xsl.async = false;
         xsl.load("table.xsl");

         var myTemplate = new ActiveXObject("MSXML2.XSLTemplate");
         myTemplate.stylesheet = xsl;

         // Transform
         var myProc = myTemplate.createProcessor();
         myProc.input = xml;

         myProc.addParameter("tablename",table);
         myProc.addParameter("regioncode",region);
         myProc.addParameter("yearcode",year);
         myProc.addParameter("scenariocode",scenario);
         myProc.addParameter("productcode",product);
         myProc.addParameter("itemcode",item);
         myProc.addParameter("xmlfile",xmlfile);
         myProc.addParameter("comparison",comparison);
         myProc.addParameter("mode",mode);

         myProc.transform();

         //document.close();
         document.open(myProc);
         document.write(myProc.output);
         // document.location.href=xmlfile+"#"+anchor;
         document.close();


   }
</SCRIPT>


<!-- create table, berschrift -->
<H1 align="center"><xsl:value-of select="/report/header"/></H1>

<!--
<P>activty=<xsl:value-of select="$activity"/></P>
<P>rowsel    =<xsl:value-of select="$rowsel"/></P>
<P>countrysel=<xsl:value-of select="$regionSel"/></P>
<P>itemcode=<xsl:value-of select="$itemcode"/></P>
<P>itemnode=<xsl:value-of select="$itemNode"/></P>
<P>colw=<xsl:value-of select="$colWidth"/></P>
<P>icolw=<xsl:value-of select="$innercolWidth"/></P>
<P>innercolumn<xsl:value-of select="$innercolumn"/></P>
<P>row=<xsl:value-of select="$row"/></P>

-->

<HR/>
    <!--
    <TABLE>
    <TR><TD>Start</TD>
        <TD>yearNode      =<xsl:value-of select="($yearNode)"/></TD>
        <TD>regionNode    =<xsl:value-of select="($regionNode)"/></TD>
        <TD>tablename     =<xsl:value-of select="($tablename)"/></TD>
        <TD>scenarioNode  =<xsl:value-of select="($scenarioNode)"/></TD>
        <TD>productNode   =<xsl:value-of select="($productNode)"/></TD>
        <TD>itemNode      =<xsl:value-of select="($itemNode)"/></TD>
    </TR>
    </TABLE>
    -->

<!--  -->
<!--                                                                                                                             -->
<!--          Scroll-down menus for tables and dimensions not comprised in current table                                         -->
<!--                                                                                                                             -->
<!-- -->

<TABLE align="center" width="100%">
<TR>

   <TD class="scrollbox"><form name="formTab" align="center">
   <select name="site" size="1">

         <xsl:attribute name="onChange">
          <xsl:text>call_parser("</xsl:text>
          <xsl:value-of select="$regioncode"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$yearcode"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$scenariocode"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$productcode"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$itemcode"/><xsl:text>",</xsl:text>
          <xsl:text>value</xsl:text><xsl:text>,"</xsl:text>
          <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
         </xsl:attribute>

      <option value="">Select table ...</option>
      <xsl:for-each select="/report/items">
          <option><xsl:attribute name="value"><xsl:value-of select="@table"/></xsl:attribute><xsl:value-of select="@table"/></option>
      </xsl:for-each>

   </select></form></TD>

   <xsl:if test="$column!='countries' and $innercolumn!='countries' and ($row!='countries' or $mode = 'draw')and $innerrow!='countries'">
      <TD  class="scrollbox"><form name="formReg" align="center">
      <select name="site" size="1">

            <xsl:attribute name="onChange">
             <xsl:text>call_parser(value,"</xsl:text>
             <xsl:value-of select="$yearcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$scenariocode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$productcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$itemcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$tablename"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
            </xsl:attribute>


            <option value="">Select region ...</option>

            <xsl:for-each select="$regionSel">

                <xsl:variable name="i1" select="name"/>
                <xsl:variable name="i2" select="key"/>

                <option><xsl:attribute name="value"><xsl:value-of select="$i2"/></xsl:attribute><xsl:value-of select="$i1"/></option>
            </xsl:for-each>
      </select></form></TD>
   </xsl:if>

   <xsl:if test="$column!='years' and $innercolumn!='years' and ($row!='years' or $mode = 'draw') and $innerrow!='years' and count($yearSel)!=1">
      <TD class="scrollbox"><form name="formYear" align="center">
      <select name="site" size="1">

            <xsl:attribute name="onChange">
             <xsl:text>call_parser("</xsl:text>
             <xsl:value-of select="$regioncode"/><xsl:text>",value,"</xsl:text>
             <xsl:value-of select="$scenariocode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$productcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$itemcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$tablename"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
             </xsl:attribute>

            <option value="">Select year </option>

            <xsl:for-each select="$yearSel">

                <xsl:variable name="i1" select="name"/>
                <xsl:variable name="i2" select="key"/>

                <option><xsl:attribute name="value"><xsl:value-of select="$i2"/></xsl:attribute><xsl:value-of select="$i1"/></option>
            </xsl:for-each>
      </select></form></TD>
   </xsl:if>

   <xsl:if test="$column!='scenarios' and $innercolumn!='scenarios' and ($row!='scenarios' or $mode = 'draw') and $innerrow!='scenarios' and count($scenarioSel)!=1">
      <TD class="scrollbox"><form name="formScen" align="center">
      <select name="site" size="1">

            <xsl:attribute name="onChange">
             <xsl:text>call_parser("</xsl:text>
             <xsl:value-of select="$regioncode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$yearcode"/><xsl:text>",value,"</xsl:text>
             <xsl:value-of select="$productcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$itemcode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$tablename"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
            </xsl:attribute>

            <option value="">Select scenario </option>

            <xsl:for-each select="$scenarioSel">

                <xsl:variable name="i1" select="name"/>
                <xsl:variable name="i2" select="key"/>

                <option><xsl:attribute name="value"><xsl:value-of select="$i2"/></xsl:attribute><xsl:value-of select="$i1"/></option>
            </xsl:for-each>
      </select></form></TD>
   </xsl:if>


   <xsl:if test="$column!='products' and $innercolumn!='products' and ($row!='products' or $mode = 'draw')
        and $innerrow!='products'
        and ( ($activity='no' and count($productSel)!=1) or ( $activity='yes' and count($activitySel)!=1) )">
      <TD class="scrollbox"><form name="formPro" align="center">
      <select name="site" size="1">

            <xsl:attribute name="onChange">
             <xsl:text>call_parser("</xsl:text>
             <xsl:value-of select="$regioncode"/><xsl:text>", "</xsl:text>
             <xsl:value-of select="$yearcode"/><xsl:text>", "</xsl:text>
             <xsl:value-of select="$scenariocode"/><xsl:text>",value,"</xsl:text>
             <xsl:value-of select="$itemcode"/><xsl:text>", "</xsl:text>
             <xsl:value-of select="$tablename"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
            </xsl:attribute>


            <xsl:if test="($activity)='no'">
               <option value="">Select product</option>
               <xsl:for-each select="$productSel">

                   <xsl:variable name="i1" select="name"/>
                   <xsl:variable name="i2" select="key"/>

                   <option><xsl:attribute name="value"><xsl:value-of select="$i2"/></xsl:attribute><xsl:value-of select="$i1"/></option>
               </xsl:for-each>
            </xsl:if>

            <xsl:if test="($activity)='yes'">
               <option value="">Select activity</option>
               <xsl:for-each select="$activitySel">

                   <xsl:variable name="i1" select="name"/>
                   <xsl:variable name="i2" select="key"/>

                   <option><xsl:attribute name="value"><xsl:value-of select="$i2"/></xsl:attribute><xsl:value-of select="$i1"/></option>
                </xsl:for-each>
            </xsl:if>
      </select></form></TD>
   </xsl:if>


   <xsl:if test="$column!='items' and $innercolumn!='items' and ($row!='items' or $mode = 'draw') and $innerrow!='items' and count(report/items[@table=$tablename]/item)!=1">
      <TD class="scrollbox"><form name="formItem" align="center">
      <select name="site" size="1">

            <xsl:attribute name="onChange">
             <xsl:text>call_parser("</xsl:text>
             <xsl:value-of select="$regioncode"/><xsl:text>", "</xsl:text>
             <xsl:value-of select="$yearcode"/><xsl:text>", "</xsl:text>
             <xsl:value-of select="$scenariocode"/><xsl:text>", "</xsl:text>
             <xsl:value-of select="$productcode"/><xsl:text>",value,"</xsl:text>
             <xsl:value-of select="$tablename"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
            </xsl:attribute>

            <option value="">Select item </option>

            <xsl:for-each select="report/items[@table=$tablename]/item">

                <xsl:variable name="i1" select="name"/>
                <xsl:variable name="i2" select="key"/>

                <option><xsl:attribute name="value"><xsl:value-of select="$i2"/></xsl:attribute><xsl:value-of select="$i1"/></option>
            </xsl:for-each>
      </select></form></TD>
   </xsl:if>

   <TD class="scrollbox"><form name="formComp" align="center">
   <select name="site" size="1">

         <xsl:attribute name="onChange">
          <xsl:text>call_parser("</xsl:text>
          <xsl:value-of select="$regioncode"/><xsl:text>", "</xsl:text>
          <xsl:value-of select="$yearcode"/><xsl:text>", "</xsl:text>
          <xsl:value-of select="$scenariocode"/><xsl:text>", "</xsl:text>
          <xsl:value-of select="$productcode"/><xsl:text>", "</xsl:text>
          <xsl:value-of select="$itemcode"/><xsl:text>", "</xsl:text>
          <xsl:value-of select="$tablename"/>
          <xsl:text>",value,"</xsl:text>
          <xsl:value-of select="$mode"/><xsl:text>","</xsl:text>
          <xsl:value-of select="$xmlfile"/><xsl:text>","TOP")</xsl:text>
         </xsl:attribute>

         <option value="">Absolute or percentage differences</option>

         <option><xsl:attribute name="value">difference</xsl:attribute>absolute difference</option>
         <option><xsl:attribute name="value">percent</xsl:attribute>percentage difference</option>
         <option><xsl:attribute name="value"></xsl:attribute>none</option>

   </select></form></TD>

   <xsl:for-each select="document(string($xmlfile))">
   </xsl:for-each>

</TR>
</TABLE>
<HR/>
<H2 align="center"><xsl:value-of select="$tablename"/></H2>

<!--  -->
<!--                                                                                                                             -->
<!--                                          Beginn der eigentlichen Tabelle                                                    -->
<!--                                                                                                                             -->
<!--  -->

<table class="table" align="center" width="100%">

    <!--

    <TR><TD>Start</TD>
        <TD>column      =<xsl:value-of select="($column)"/></TD>
        <TD>row         =<xsl:value-of select="($row)"/></TD>
        <TD>innercolumn =<xsl:value-of select="($innercolumn)"/></TD>
        <TD>innerrow    =<xsl:value-of select="($innerrow)"/></TD>
        <TD>yearcode    =<xsl:value-of select="($yearcode)"/></TD>
        <TD>regioncode  =<xsl:value-of select="($regioncode)"/></TD>
    </TR>
    -->


  <!-- Ausgabe des ersten headers der Tabelle -->

  <!--- innerrow wird uebergeben, um eine leere Spalte zu uebergeben -->

  <xsl:call-template name="header">
     <xsl:with-param name="region"    select="$regioncode"/>
     <xsl:with-param name="year"      select="$yearNode"/>
     <xsl:with-param name="anchor"    select="TOP"/>
     <xsl:with-param name="mode"      select="$mode"/>
  </xsl:call-template>

  <!-- Aufruf der Reihenfunktion -->

  <xsl:call-template name="row">


    <xsl:with-param name="region"      select="$regionNode"/>
    <xsl:with-param name="year"        select="$yearNode"/>
    <xsl:with-param name="scenario"    select="$scenarioNode"/>
    <xsl:with-param name="product"     select="$productNode"/>
    <xsl:with-param name="item"        select="$itemNode"/>
    <xsl:with-param name="mode"        select="$mode"/>

    <!-- Falls die products/activities als ussere Reihe dargestellt  -->
    <!-- werden sollen, wird auch eine Aggregatliste ausgegeben       -->
    <xsl:with-param name="aggreglist">
      <xsl:choose>
        <xsl:when test="count($rowNode/name[@aggreg='yes'])">
          <xsl:value-of select="'yes'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'no'"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

<!-- Ende der Tabelle -->
</table>
<A href="#TOP"><span class="cell">nach oben</span></A>
<HR/>
<P align="right"><font size="-2"><B>Copyright of the XSL/XML table tool: </B>Wolfgang Britz and Heiko Buschbell, Institute for Agricultural Policy, Bonn, Germany, 2003</font></P>
</body>
</html>

</xsl:template>    <!-- Ende des Wurzel (/) Templates -->

<!-- Reihenfunktion -->
<xsl:template name="row">


  <xsl:param name="region"/>
  <xsl:param name="year"/>
  <xsl:param name="scenario"/>
  <xsl:param name="product"/>
  <xsl:param name="item"/>
  <xsl:param name="mode"/>
  <xsl:param name="aggreglist"/>

  <xsl:variable name="nAggreg" select="count($rowNode/name[@aggreg='yes'][contains(@sel,$rowsel)])"/>




  <!-- Schleife ber alle Reihen wenn keine Aggregatliste ausgegeben werden soll, luft die die Schleife -->
  <!-- zuerst ber alle Aggregate, dann wird die Funktion rekursiv aufgerufen und die Schleife luft     -->
  <!-- erneut, aber diesmal "normal", ber alle Reihen                                                   -->
  <xsl:for-each select="$rowNode/name[@aggreg='yes'][$aggreglist='yes'][contains(@sel,$rowsel)] | $rowNode/name[$aggreglist='no'][contains(@sel,$rowsel)]">

    <!-- von den Variablen die fr die Ausgabe bentigt werden, werden nur die besetzt, die in row(node) -->
    <!-- zu finden ist                                                                                   -->

    <xsl:variable name="rregion"    select="following-sibling::key[1][$row='countries']"/>
    <xsl:variable name="ryear"      select="following-sibling::key[1][$row='years']"/>
    <xsl:variable name="rscenario"  select="following-sibling::key[1][$row='scenarios']"/>
    <xsl:variable name="rproduct"   select="following-sibling::key[1][$row='products']"/>
    <xsl:variable name="ritem"      select="following-sibling::key[1][$row='items']"/>
    <xsl:variable name="runit"      select="following-sibling::unit[1][$row='items']"/>

    <!-- Falls products/activities in der row oder der innerrow stehen, wird vor jedem Aggregatkomplex   -->
    <!-- erneut der header ausgegeben (natrlich nicht vor der Aggregatliste, da steht er ja schon)      -->

    <xsl:if test="( ( (@aggreg='yes' and $aggreglist='no') or (@header='yes') ) and ($mode='text') )">

      <xsl:call-template name="header">
        <xsl:with-param name="region"    select="$rregion"/>
        <xsl:with-param name="year"      select="$ryear"/>
        <xsl:with-param name="anchor"    select="."/>
        <xsl:with-param name="mode"      select="$mode"/>
      </xsl:call-template>

    </xsl:if>

    <!--


    <TR><TD>ROW</TD>
        <TD>row      =<xsl:value-of select="($row)"/></TD>
        <TD>column   =<xsl:value-of select="($column)"/></TD>
        <TD>product  =<xsl:value-of select="($product)"/></TD>
        <TD>rproduct  =<xsl:value-of select="($rproduct)"/></TD>
        <TD>item     =<xsl:value-of select="($item)"/></TD>
        <TD>ritem     =<xsl:value-of select="($ritem)"/></TD>
        <TD>rscenario =<xsl:value-of select="($rscenario)"/></TD>
        <TD>yea r     =<xsl:value-of select="($year)"/></TD>
        <TD>ryear     =<xsl:value-of select="($ryear)"/></TD>
        <TD>region   =<xsl:value-of select="($region)"/></TD>
        <TD>rregion  =<xsl:value-of select="($rregion)"/></TD>
        <TD>aggreglist =<xsl:value-of select="($aggreglist)"/></TD>
    </TR>

    -->


    <xsl:variable name="rowname" select="." />
    <xsl:variable name="aggreg"><xsl:if test="@aggreg='yes'">yes</xsl:if></xsl:variable>
    <xsl:variable name="rowkey" select="following-sibling::key[1]"/>

     <!--
        <TD>aggreglist =<xsl:value-of select="($aggreglist)"/></TD>
        <TD>aggreg     =<xsl:value-of select="($aggreg)"/></TD>
        <TD>rowname    =<xsl:value-of select="($rowname)"/></TD>
     -->


    <!-- zwei verschiedene Flle sind vonnten, da html bei inneren Reihen nicht hierarchisch aufgebaut  -->
    <!-- ist: die Ausgabe mit und ohne innere Reihen                                                     -->
    <xsl:if test="$innerrow and $mode='text'">

      <xsl:for-each select="$innerrowNode/name[contains(@sel,$innerrowsel)]">

        <tr>

        <xsl:if test="position()=1">
           <td class="rowname">
           <!-- Das ussere Namensfeld wird ber die Anzahl der inneren Reihen gespannt                     -->
           <xsl:attribute name="rowspan"><xsl:value-of select="$innerrownum"/></xsl:attribute>

             <xsl:if test="$setLinks='yes'">
                <a>
                <!-- die Aggregatliste und die einzelnen Aggregate (falls vorhanden) werden miteinander ber   -->
                <!-- Kreuz im aktuellen Dokument verlinkt                                                      -->
                <xsl:if test="$aggreg='yes'">
                  <xsl:choose>
                    <xsl:when test="$aggreglist='yes'">
                      <xsl:attribute name="href">
                        <xsl:value-of select="$xmlfile"/><xsl:text>#</xsl:text><xsl:value-of select="$rowkey"/>
                      </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:attribute name="href"><xsl:value-of select="$xmlfile"/><xsl:text>#TOP</xsl:text></xsl:attribute>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:if>

                <xsl:if test="$aggreglist!='yes'">
                     <xsl:attribute name="name"><xsl:value-of select="$rowkey"/></xsl:attribute>
                </xsl:if>

                <!-- Ausgabe des Reihennamens                                                                  -->
                <xsl:value-of select="$rowname" />
                <xsl:if test="$runit!=''"><BR/><span class="unit"><xsl:value-of select="$runit" /></span></xsl:if>
                <xsl:if test="$row='scenarios'">
                   <xsl:call-template name="compscen">
                        <xsl:with-param name="scenario" select="."/>
                   </xsl:call-template>
                </xsl:if>
                </a>
             </xsl:if>
             <xsl:if test="$setLinks!='yes'">
                <xsl:value-of select="$rowname" />
                <xsl:if test="$runit!=''"><BR/><span class="unit"><xsl:value-of select="$runit" /></span></xsl:if>
             </xsl:if>

             <xsl:if test="$row='scenarios'">
                 <xsl:call-template name="compscen">
                      <xsl:with-param name="scenario"      select="."/>
                 </xsl:call-template>
            </xsl:if>

            <xsl:call-template name="rowput">

                  <xsl:with-param name="region"      select="$rregion  [$row='countries']   | following-sibling::key[1][$innerrow='countries']  | $region   [$row!='countries'   and $innerrow!='countries']"/>
                  <xsl:with-param name="year"        select="$ryear    [$row='years']       | following-sibling::key[1][$innerrow='years']      | $year     [$row!='years'       and $innerrow!='years']"/>
                  <xsl:with-param name="scenario"    select="$rscenario[$row='scenarios']   | following-sibling::key[1][$innerrow='scenarios']  | $scenario [$row!='scenarios'   and $innerrow!='scenarios']"/>
                  <xsl:with-param name="product"     select="$rproduct [$row='products']    | following-sibling::key[1][$innerrow='products']   | $product  [$row!='products'    and $innerrow!='products']"/>
                  <xsl:with-param name="item"        select="$ritem    [$row='items']       | following-sibling::key[1][$innerrow='items']      | $item     [$row!='items'       and $innerrow!='items']"/>
                  <xsl:with-param name="mode"        select="$mode" />
                  <xsl:with-param name="setDrawLink" select="'BR'" />
            </xsl:call-template>
           </td>

        </xsl:if>

        <!-- Ausgabe des Namens der inneren Reihe                                                    -->
           <td class="innerrowname">
                  <xsl:value-of select="."/>

                  <xsl:variable name="irunit" select="following-sibling::unit[1][$innerrow='items']"/>
                  <xsl:if test="$irunit!=''"><BR/><span class="unit"><xsl:value-of select="$irunit" /></span></xsl:if>

                  <xsl:if test="$innerrow='scenarios'">
                      <xsl:call-template name="compscen">
                           <xsl:with-param name="scenario"      select="."/>
                      </xsl:call-template>
                  </xsl:if>
           </td>

        <!-- Ausgabe der Spalten mit der Funktion rowput                                            -->
        <xsl:call-template name="rowput">

              <xsl:with-param name="region"      select="$rregion  [$row='countries']   | following-sibling::key[1][$innerrow='countries']  | $region   [$row!='countries'   and $innerrow!='countries']"/>
              <xsl:with-param name="year"        select="$ryear    [$row='years']       | following-sibling::key[1][$innerrow='years']      | $year     [$row!='years'       and $innerrow!='years']"/>
              <xsl:with-param name="scenario"    select="$rscenario[$row='scenarios']   | following-sibling::key[1][$innerrow='scenarios']  | $scenario [$row!='scenarios'   and $innerrow!='scenarios']"/>
              <xsl:with-param name="product"     select="$rproduct [$row='products']    | following-sibling::key[1][$innerrow='products']   | $product  [$row!='products'    and $innerrow!='products']"/>
              <xsl:with-param name="item"        select="$ritem    [$row='items']       | following-sibling::key[1][$innerrow='items']      | $item     [$row!='items'       and $innerrow!='items']"/>
              <xsl:with-param name="mode"        select="$mode" />
        </xsl:call-template>
        <!-- Ausgabe aller inneren Reihen abgeschlossen -->
        </tr>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="$mode='draw' and $aggreglist='no'
                                            and  (($rregion=$region      and  $row='countries')
                                             or   ($ryear=$year          and  $row='years')
                                             or   ($rscenario=$scenario  and  $row='scenarios')
                                             or   ($rproduct=$product    and  $row='products')
                                             or   ($rproduct=$item       and  $row='items')      )">

      <tr>
      <td class="rowname">

         <xsl:value-of select="$rowname"/>

         <BR/><BR/><BR/><BR/>
         <a class="link">
             <xsl:attribute name="href"></xsl:attribute>
             <xsl:attribute name="onClick">
             <xsl:text>call_parser("</xsl:text>
             <xsl:value-of select="$region"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$year"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$scenario"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$product"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$item"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$tablename"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$comparison"/><xsl:text>","</xsl:text>
             <xsl:value-of select="'text'"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$xmlfile"/><xsl:text>","</xsl:text>
             <xsl:value-of select="$rowkey"/><xsl:text>")</xsl:text>
            </xsl:attribute>

            <xsl:value-of select="'Back to table'"/>
         </a>

      </td>

      <td width="100%" height="500px">

       <embed src="test.svg" width="100%" height="100%" type="image/svg+xml" name="SVGEmbed"/>

       <script type="text/javascript">

           var ColLabel;
           ColLabel = new Array(

           <xsl:for-each select="$colNode/name[contains(@sel,$colsel)]">
              <xsl:text>"</xsl:text><xsl:value-of select="."/><xsl:text>",</xsl:text>
           </xsl:for-each>
           " ");

           var InnerRowLabel;
           InnerRowLabel = new Array(

           <xsl:for-each select="$innerrowNode/name[contains(@sel,$innerrowsel)]">
              <xsl:text>"</xsl:text><xsl:value-of select="."/><xsl:text>",</xsl:text>
           </xsl:for-each>
           " ");

           var InnerColLabel;
           InnerColLabel = new Array(

           <xsl:for-each select="$innercolNode/name[contains(@sel,$innercolsel)]">
              <xsl:text>"</xsl:text><xsl:value-of select="."/><xsl:text>",</xsl:text>
           </xsl:for-each>
           " ");

          <xsl:text>var nRow         =</xsl:text><xsl:value-of select="$rownum"/><xsl:text>;</xsl:text>
          <xsl:text>var nInnerRowOri =</xsl:text><xsl:value-of select="$innerrownum"/><xsl:text>;</xsl:text>
          <xsl:text>var nCol         =</xsl:text><xsl:value-of select="$colnum"/><xsl:text>;</xsl:text>
          <xsl:text>var nInnerColOri =</xsl:text><xsl:value-of select="$innercolnum"/><xsl:text>;</xsl:text>

          <xsl:text>var iRow,iCol,iInnerRow,iInnerCol;</xsl:text>
          <xsl:text>var data;</xsl:text>
          <xsl:text>data = new Array(</xsl:text>

          <xsl:for-each select="$innerrowNode/name[contains(@sel,$innerrowsel)]">
              <xsl:call-template name="rowput">

                    <xsl:with-param name="region"      select="$rregion  [$row='countries']   | following-sibling::key[1][$innerrow='countries']  | $region   [$row!='countries'   and $innerrow!='countries']"/>
                    <xsl:with-param name="year"        select="$ryear    [$row='years']       | following-sibling::key[1][$innerrow='years']      | $year     [$row!='years'       and $innerrow!='years']"/>
                    <xsl:with-param name="scenario"    select="$rscenario[$row='scenarios']   | following-sibling::key[1][$innerrow='scenarios']  | $scenario [$row!='scenarios'   and $innerrow!='scenarios']"/>
                    <xsl:with-param name="product"     select="$rproduct [$row='products']    | following-sibling::key[1][$innerrow='products']   | $product  [$row!='products'    and $innerrow!='products']"/>
                    <xsl:with-param name="item"        select="$ritem    [$row='items']       | following-sibling::key[1][$innerrow='items']      | $item     [$row!='items'       and $innerrow!='items']"/>
                    <xsl:with-param name="mode"        select="$mode" />

              </xsl:call-template>
          </xsl:for-each>

          <xsl:if test="$innerrow=''">
             <xsl:call-template name="rowput">

                <xsl:with-param name="region"      select="$rregion  [$row='countries'] | following-sibling::key[1]   [$innerrow='countries'] | $region   [$row!='countries']"/>
                <xsl:with-param name="year"        select="$ryear    [$row='years']     | following-sibling::key[1]   [$innerrow='years']     | $year     [$row!='years'    ]"/>
                <xsl:with-param name="scenario"    select="$rscenario[$row='scenarios'] | following-sibling::key[1]   [$innerrow='scenarios'] | $scenario [$row!='scenarios']"/>
                <xsl:with-param name="product"     select="$rproduct [$row='products']  | following-sibling::key[1]   [$innerrow='products']  | $product  [$row!='products' ]"/>
                <xsl:with-param name="item"        select="$ritem    [$row='items']     | following-sibling::key[1]   [$innerrow='items']     | $item     [$row!='items'    ]"/>
                <xsl:with-param name="mode"        select="$mode" />

             </xsl:call-template>
          </xsl:if>

          <xsl:text>0,0);</xsl:text>


                color  = new Array("blue","red","green","yellow","silver",
                                   "gray","olive","purple","teal","maroon",
                                   "lime","aqua","fuchsia",

                                   "blue","red","green","yellow","silver",
                                   "gray","red","purple","teal","maroon",
                                   "lime","aqua","fuchsia",

                                   "blue","red","green","yellow","silver",
                                   "gray","red","purple","teal","maroon",
                                   "lime","aqua","fuchsia",

                                   "blue","red","green","yellow","silver",
                                   "gray","red","purple","teal","maroon",
                                   "lime","aqua","fuchsia",

                                   "blue","red","green","yellow","silver",
                                   "gray","red","purple","teal","maroon",
                                   "lime","aqua","fuchsia",

                                   "blue","red","green","yellow","silver",
                                   "gray","red","purple","teal","maroon",
                                   "lime","aqua","fuchsia",

                                   "blue","red","green","yellow","silver",
                                   "gray","red","purple","teal","maroon",
                                   "lime","aqua","fuchsia",


                                   "blue","red","green","yellow","silver",
                                   "gray","olive","purple","teal","maroon",
                                   "lime","aqua","fuchsia");





                var xmax,xmin,xdig10,svgroot,svgdoc;


                var nInnerRow = Math.max(nInnerRowOri,1);
                var nInnerCol = Math.max(nInnerColOri,1);

                var xMaxp = 1000;
                var yMaxp =  500;

                var xOffset  = xMaxp/3;
                var yOffset  = yMaxp/10;

                var nDrawCols = nCol;

                var xInterval = (xMaxp-xOffset-xOffset/10)/(nDrawCols);

                function init(evt)
                {

                      svgdoc  = evt.getTarget().getOwnerDocument();
                      svgroot = svgdoc.getDocumentElement();

                      text = svgdoc.createElement("text")
                      text.setAttribute("id","0");
                      svgroot.appendChild(text);

                      xmax = -100000000;
                      xmin = +100000000;
                      var curVal;

                      // find minimum and maximum values

                      iRow = 0;
                      for (iInnerRow = 0; iInnerRow != nInnerRow;  iInnerRow++)
                      for (iCol      = 0; iCol      != nCol;       iCol++)
                      for (iInnerCol = 0; iInnerCol != nInnerCol;  iInnerCol++)
                      {

                          if ( nInnerColOri )
                             curVal = data[ iRow*nCol*nInnerCol  + iCol*nInnerCol + iInnerCol];
                          else
                             curVal = data[ iRow*nInnerRow*nCol  + iInnerRow*nCol + iCol];

                          if ( curVal != 1.E-10)
                          {
                             xmax = Math.max(xmax,curVal);
                             xmin = Math.min(xmin,curVal);
                          }
                      }

                      niceMinMax();
                      drawGridVertical();
                      drawAxis();

                      drawGridHorizontal();

                      if ( nInnerColOri )
                         drawBars();
                      else
                         drawPoints();

                      drawLegend();

                }



                function niceMinMax()
                {
                    if ( xmax == -100000000 )
                                           xmax=1;

                   if ( xmin == +100000000 )
                                           xmin=0;

                   if ( nInnerRowOri == 0)
                      xmin = Math.min(xmin,0);

                   if ( nInnerRowOri == 0)
                      xmax = Math.max(xmax,0);

                   if ( xmin == xmax )
                       xmax = Math.max(xmin*10.,xmax+1);


                   var exp;
                   exp = Math.floor ( Math.log( Math.max(Math.abs(xmax),Math.abs(xmin))    ) / Math.log(10) );
                   xdig10 = Math.pow(10,exp);

                   xmax = Math.ceil  ( xmax / xdig10    ) * xdig10;
                   xmin = Math.floor ( xmin / xdig10    ) * xdig10;

                   nGrid = (xmax-xmin) / xdig10;


                   iGrid  = Math.min(10,nGrid);
                   if ( iGrid != nGrid )
                      xdig10 = xdig10*2;

                   iGrid  = Math.max(4,nGrid);
                   if ( iGrid != nGrid )
                      xdig10 = xdig10/2;

                }

                function highLight(iLight,mode)
                {
                    id = 0;

                    if ( nInnerColOri )
                    {
                       for (iCol = 0; iCol != nCol;  iCol++)
                       for (iInnerCol=0; iInnerCol != nInnerCol; iInnerCol++)
                       {
                           if ( iInnerCol == iLight )
                           {
                               text = svgdoc.getElementById(id)
                               if ( mode == 1)
                                 text.getStyle().setProperty("visibility","visible");
                               else
                                 text.getStyle().setProperty("visibility","hidden");
                           }
                           id++
                       }
                    }
                    else
                    {
                       for (iInnerRow=0; iInnerRow != nInnerRow; iInnerRow++)
                       for (iCol    = 0; iCol != nCol;  iCol++)
                       {
                           if ( iInnerRow == iLight )
                           {
                               if ( mode == 1)
                               {
                                 svgdoc.getElementById(id).setAttribute("stroke-width",5);
                                 svgdoc.getElementById("text"+id).getStyle().setProperty("visibility","visible");
                               }
                               else
                               {
                                 svgdoc.getElementById(id).setAttribute("stroke-width",3);
                                 svgdoc.getElementById("text"+id).getStyle().setProperty("visibility","hidden");
                               }
                           }
                           id++;
                       }
                    }
                }

                function drawBars()
                {
                      var iRow = 0;
                      var id   = 0;
                      var y    = yMaxp - yOffset - ( 0 -xmin)/(xmax-xmin) * (yMaxp-yOffset*1.30);

                      var barWidth = xInterval / (2*nInnerCol +1);
                      var x = xOffset;

                      for (iCol  = 0; iCol != nCol;  iCol++)
                      {

                         x +=barWidth;

                         for (iInnerCol=0; iInnerCol != nInnerCol; iInnerCol++)
                         {
                             curVal = data[ iRow*nCol*nInnerCol  + iCol*nInnerCol + iInnerCol];
                             curY   = yMaxp - yOffset - ( curVal -xmin)/(xmax-xmin) * (yMaxp-yOffset*1.30);

                             {
                                rect = svgdoc.createElement("rect")
                                rect.setAttribute("x",x);

                                if ( Math.abs(curVal) != curVal )
                                {
                                   rect.setAttribute("y",y);
                                   rect.setAttribute("height",Math.max(curY-y,1));
                                }
                                else
                                {
                                   rect.setAttribute("y",curY);
                                   rect.setAttribute("height",Math.max(y-curY,1));
                                }

                                rect.setAttribute("width",barWidth);
                                rect.setAttribute("fill",color[iInnerCol]);
                          //    rect.setAttribute("filter","url(#Drop_Shadow)");
                                rect.setAttribute("stroke-width",5);
                                rect.setAttribute("id",id);

                                if ( curVal == 1.E-10 || curVal == 0.0  )
                                  rect.setAttribute("visibility","hidden");

                                svgroot.appendChild(rect);


                                text = svgdoc.createElement("text")
                                text.setAttribute("x",x);
                                text.setAttribute("y",curY);
                                text.setAttribute("id","text"+id);
                                text.setAttribute("class","point");

                                if ( curVal != 1.E-10)
                                {
                                   var textData = svgdoc.createTextNode(curVal);
                                   text.appendChild(textData);
                                }
                                svgroot.appendChild(text);
                             }

                             x +=barWidth+barWidth;

                             id++;
                         }

                      }

                }

                function drawPoints()
                {

                   for (iMode   = 0; iMode != 2;  iMode++)
                   {
                      var id   = 0;
                      var iRow = 0;
                      var iCnt = 0;
                      lstY   = 0;
                      for (iInnerRow=0; iInnerRow != nInnerRow; iInnerRow++)
                      {

                         lstVal = 1.E-10;
                         var x = xOffset;

                         for (iCol    = 0; iCol != nCol;  iCol++)
                         {
                             curVal = data[ iRow*nInnerRow*nCol  + iInnerRow*nCol + iCol];
                             curY   = yMaxp - yOffset - ( curVal -xmin)/(xmax-xmin) * (yMaxp-yOffset*1.30);

                             if ( iMode == 0 )
                             {

                                line = svgdoc.createElement("line")
                                line.setAttribute("x1",x);
                                line.setAttribute("y1",lstY);

                                x += xInterval;
                                line.setAttribute("x2",x);
                                line.setAttribute("y2",curY);
                                line.setAttribute("stroke",color[iCnt]);
                                line.setAttribute("stroke-opacity",1);
                                line.setAttribute("stroke-width",3);
                                line.setAttribute("id",id);
                          //    line.setAttribute("filter","url(#Drop_Shadow)");

                                if ( curVal == 1.E-10 || lstVal == 1.E-10 || iCol == 0)
                                   line.setAttribute("visibility","hidden");
                                svgroot.appendChild(line);

                                circle = svgdoc.createElement("circle")
                                circle.setAttribute("cx",x);
                                circle.setAttribute("cy",curY);
                                circle.setAttribute("r",5);
                                circle.setAttribute("stroke","black");
                                circle.setAttribute("fill",color[iCnt]);
                                circle.setAttribute("stroke-opacity",0.8);
                                circle.setAttribute("stroke-width",1);
                          //    circle.setAttribute("filter","url(#Drop_Shadow)");
                                svgroot.appendChild(circle);
                                if ( curVal == 1.E-10 )
                                   circle.setAttribute("visibility","hidden");
                              }
                              else
                              {
                                x += xInterval;
                                text = svgdoc.createElement("text")
                                text.setAttribute("x",x);
                                text.setAttribute("y",curY);
                                text.setAttribute("id","text"+id);
                                text.setAttribute("class","point");

                                if ( curVal != 1.E-10)
                                {
                                   var textData = svgdoc.createTextNode(curVal);
                                   text.appendChild(textData);
                                }
                                svgroot.appendChild(text);
                             }
                             id++;

                             lstY   = curY;
                             lstVal = curVal;
                         }

                         iCnt++;

                      }
                   }

                }


                function drawGridHorizontal()
                {

                      nStep = (xmax-xmin)/xdig10 + 1;
                      curVal = xmin;

                      for ( iStep = 0; iStep != nStep; iStep++)
                      {
                         drawGridHorizontalLine(curVal);
                         curVal +=xdig10;
                      }

                      if ( Math.abs(xmin) != xmin )
                         drawGridHorizontalLine(0);

                }

                function drawGridHorizontalLine(curVal)
                {

                    curY   = yMaxp - yOffset - ( curVal -xmin)/(xmax-xmin) * (yMaxp-yOffset*1.30);

                    line = svgdoc.createElement("line")
                    line.setAttribute("x1",xOffset*0.99);
                    line.setAttribute("y1",curY);
                    line.setAttribute("x2",xMaxp*0.98);
                    line.setAttribute("y2",curY);
                    line.setAttribute("class","gridline");
                    svgroot.appendChild(line);

                    text = svgdoc.createElement("text")
                    text.setAttribute("x",xOffset*0.98);
                    text.setAttribute("y",curY);
                    text.setAttribute("class","HaxisLabel");

                    var textData = svgdoc.createTextNode(curVal);
                    text.appendChild(textData);
                    svgroot.appendChild(text);

                }

                function drawGridVertical()
                {

                      var iGrid = xOffset + xInterval;

                      for ( iCol = 0; iCol != nCol; iCol++)
                      {

                         line = svgdoc.createElement("line")
                         line.setAttribute("x1",iGrid);
                         line.setAttribute("y1",yOffset*.25);
                         line.setAttribute("x2",iGrid);
                         line.setAttribute("y2",yMaxp-yOffset*0.95);

                         svgroot.appendChild(line);

                         text = svgdoc.createElement("text")

                         if ( nInnerColOri )
                            text.setAttribute("x",iGrid - xInterval/2);
                         else
                            text.setAttribute("x",iGrid );


                         text.setAttribute("y",yMaxp-yOffset*0.45);

                         text.setAttribute("class","VaxisLabel");

                         var textData = svgdoc.createTextNode(ColLabel[iCol]);
                         text.appendChild(textData);
                         svgroot.appendChild(text);
                        // text.setAttribute("filter","url(#Drop_Shadow)");

                         iGrid += xInterval;

                      }

                }


                function drawAxis()
                {
                   line = svgdoc.createElement("line")
                   line.setAttribute("x1",xOffset);
                   line.setAttribute("y1",yOffset*0.25);
                   line.setAttribute("x2",xOffset);
                   line.setAttribute("y2",yMaxp-yOffset);
                   line.setAttribute("class","axis");
                   line.setAttribute("stroke","blue");
                   svgroot.appendChild(line);

                   line = svgdoc.createElement("line")
                   line.setAttribute("x1",xOffset);
                   line.setAttribute("y1",yMaxp-yOffset);
                   line.setAttribute("x2",xMaxp*0.99);
                   line.setAttribute("y2",yMaxp-yOffset);
                   line.setAttribute("class","axis");
                   line.setAttribute("stroke","blue");
                   svgroot.appendChild(line);
                }




                function drawLegend()
                {

                   curY = yOffset/10;

                   nLegend = Math.max(nInnerRow * nInnerCol,10);
                   yOff = (yMaxp-2*yOffset)/(nLegend+1);

                   for ( iInnerRow = 0; iInnerRow != nInnerRow; iInnerRow++)
                   for ( iInnerCol = 0; iInnerCol != nInnerCol; iInnerCol++)
                   {
                      curY   += yOff;
                      curX    = xOffset/10;

                      rect = svgdoc.createElement("rect")
                      rect.setAttribute("x",curX);
                      rect.setAttribute("y",curY-yOff*0.55);
                      rect.setAttribute("width",xOffset/12);
                      rect.setAttribute("height",yOff*0.9);
                      rect.setAttribute("stroke-width",3);

                      if ( nInnerRowOri != 0)
                      {
                         rect.setAttribute("fill",color[iInnerRow]);
                         rect.setAttribute("onmouseover","highLight("+iInnerRow+",1)");
                         rect.setAttribute("onmouseout","highLight(" +iInnerRow+",0)");
                      }
                      else
                      {
                         rect.setAttribute("fill",color[iInnerCol]);
                         rect.setAttribute("onmouseover","highLight("+iInnerCol+",1)");
                         rect.setAttribute("onmouseout","highLight(" +iInnerCol+",0)");
                      }

                    //rect.setAttribute("filter","url(#Drop_Shadow)");
                      svgroot.appendChild(rect);

                      curX    = xOffset/5;

                      text = svgdoc.createElement("text")
                      text.setAttribute("x",curX);
                      text.setAttribute("y",curY);
                      text.setAttribute("class","LegendLabel");
                      if ( nInnerRowOri != 0)
                         var textData = svgdoc.createTextNode(InnerRowLabel[iInnerRow]);
                      else
                         var textData = svgdoc.createTextNode(InnerColLabel[iInnerCol]);

                      text.appendChild(textData);
                      svgroot.appendChild(text);
                   }
                }

       </script>


      </td>
      </tr>
    </xsl:if>
    <!-- test="$innerrow" -->


                    <!-- 2. Fall: keine inneren Reihen                                                                    -->
    <xsl:if test="$innerrow='' and $mode='text'">

     <tr><td class="rowname">
          <xsl:if test="$setLinks='yes'">
             <a>
               <!-- die Aggregatliste und die einzelnen Aggregate (falls vorhanden) werden miteinander      -->
               <!-- ber Kreuz im aktuellen Dokument verlinkt                                               -->
               <xsl:if test="@aggreg='yes'">
                 <xsl:choose>
                   <xsl:when test="$aggreglist='yes'">
                     <xsl:attribute name="href">
                       <xsl:value-of select="$xmlfile"/><xsl:text>#</xsl:text><xsl:value-of select="."/>
                     </xsl:attribute>
                   </xsl:when>
                   <xsl:otherwise>
                     <xsl:attribute name="href"><xsl:value-of select="$xmlfile"/><xsl:text>#TOP</xsl:text></xsl:attribute>
                     <xsl:attribute name="name"><xsl:value-of select="."/></xsl:attribute>
                   </xsl:otherwise>
                 </xsl:choose>
               </xsl:if>
               <!-- Ausgabe des Namens der Reihe                                                            -->
               <xsl:value-of select="." />
               <xsl:if test="$runit!=''"><BR/><span class="unit"><xsl:value-of select="$runit" /></span></xsl:if>
             </a>
          </xsl:if>
          <xsl:if test="$setLinks!='yes'">
             <!-- Ausgabe des Namens der Reihe                                                            -->
             <xsl:value-of select="."/>
             <xsl:if test="$runit!=''"><BR/><span class="unit"><xsl:value-of select="$runit" /></span></xsl:if>
          </xsl:if>
          <xsl:if test="$row='scenarios'">
              <xsl:call-template name="compscen">
                 <xsl:with-param name="scenario" select="."/>
              </xsl:call-template>
          </xsl:if>

        </td>

        <!-- Ausgabe der einzelnen Reihen mit der Funktion rowput                                        -->
        <xsl:call-template name="rowput">

             <xsl:with-param name="region"      select="$rregion  [$row='countries'] | following-sibling::key[1]   [$innerrow='countries'] | $region   [$row!='countries']"/>
             <xsl:with-param name="year"        select="$ryear    [$row='years']     | following-sibling::key[1]   [$innerrow='years']     | $year     [$row!='years'    ]"/>
             <xsl:with-param name="scenario"    select="$rscenario[$row='scenarios'] | following-sibling::key[1]   [$innerrow='scenarios'] | $scenario [$row!='scenarios']"/>
             <xsl:with-param name="product"     select="$rproduct [$row='products']  | following-sibling::key[1]   [$innerrow='products']  | $product  [$row!='products' ]"/>
             <xsl:with-param name="item"        select="$ritem    [$row='items']     | following-sibling::key[1]   [$innerrow='items']     | $item     [$row!='items'    ]"/>
             <xsl:with-param name="mode"        select="$mode" />
             <xsl:with-param name="setDrawLink" select="'TD'" />

        </xsl:call-template>

        </tr>
    </xsl:if>
    <!-- test="not($innerrow)" -->

    </xsl:for-each>

                  <!-- rekursiver Aufruf dieser Funktion (row) falls eine Aggregatliste ausgegeben wurde, diesmal mit    -->
                  <!-- aggreglist='no'!!                                                                                 -->

    <!-- <TR><TD>aggreglist =<xsl:value-of select="($aggreglist)"/></TD></TR> -->

    <xsl:if test="$aggreglist='yes'">
        <xsl:call-template name="row">
             <xsl:with-param name="aggreglist"  select="'no'"/>
             <xsl:with-param name="region"      select="$region"/>
             <xsl:with-param name="year"        select="$year"/>
             <xsl:with-param name="scenario"    select="$scenario"/>
             <xsl:with-param name="product"     select="$product"/>
             <xsl:with-param name="item"        select="$item"/>
             <xsl:with-param name="mode"        select="$mode"/>
       </xsl:call-template>
    </xsl:if>

</xsl:template>

<!-- ****** Funktion zur Ausgabe einzelner Reihen der Tabelle ************************************************ -->

<xsl:template name="rowput">

  <xsl:param name="region"/>
  <xsl:param name="year"/>
  <xsl:param name="scenario"/>
  <xsl:param name="product"/>
  <xsl:param name="item"/>

  <xsl:param name="mode"/>
  <xsl:param name="setDrawLink"/>

  <xsl:if test="$setDrawLink='TD' and ($innercolnum or $innerrownum)">

           <td>
           <a class="link">
               <xsl:attribute name="href"></xsl:attribute>
               <xsl:attribute name="onClick">

                           <xsl:text>call_parser("</xsl:text>
                           <xsl:value-of select="$region"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$year"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$scenario"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$product"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$item"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$tablename"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$comparison"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="'draw'"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$xmlfile"/>
                           <xsl:text>","TOP")</xsl:text>

               </xsl:attribute>
              <xsl:value-of select="'draw'"/>
           </a>
           </td>
  </xsl:if>
  <xsl:if test="$setDrawLink='BR'">

           <BR/><BR/>
           <a class="link">
               <xsl:attribute name="href"></xsl:attribute>
               <xsl:attribute name="onClick">

                           <xsl:text>call_parser("</xsl:text>
                           <xsl:value-of select="$region"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$year"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$scenario"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$product"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$item"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$tablename"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$comparison"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="'draw'"/>
                           <xsl:text>","</xsl:text><xsl:value-of select="$xmlfile"/>
                           <xsl:text>","TOP")</xsl:text>

               </xsl:attribute>
              <xsl:value-of select="'draw'"/>
           </a>
  </xsl:if>
  <xsl:if test="$setDrawLink!='BR'">

  <!--

  <TR>
  <TD>ROWPUT</TD>
  <TD>scenario=  <xsl:value-of select="$scenario"/></TD>
  <TD>region  =  <xsl:value-of select="$region"/></TD>
  <TD>year    =  <xsl:value-of select="$year"/></TD>
  <TD>item    =  <xsl:value-of select="$item"/></TD>
  <TD>product =  <xsl:value-of select="$product"/></TD>
  <TD>mode    =  <xsl:value-of select="$mode"/></TD>
  </TR>

  -->


  <!-- Schleife ber alle columns                                                                       -->
  <xsl:for-each select="$colNode/name[contains(@sel,$colsel)]">

    <!-- Besetzen der Ausgabevariablen, die in den columns stehen                                       -->

    <xsl:variable name="cregion"     select="following-sibling::key[1]  [$column='countries']"/>
    <xsl:variable name="cyear"       select="following-sibling::key[1]  [$column='years']"/>
    <xsl:variable name="cscenario"   select="following-sibling::key[1]  [$column='scenarios']"/>
    <xsl:variable name="cproduct"    select="following-sibling::key[1]  [$column='products']"/>
    <xsl:variable name="citem"       select="following-sibling::key[1]  [$column='items']"/>

    <!-- Zwei Mglichkeiten: mit oder ohne inneren columns                                              -->

    <!-- erste Mgl.: mit innereren columns                                                             -->
    <xsl:if test="$innercolumn">
       <!-- Schleife ber alle inneren columns                                                           -->

       <xsl:for-each select="$innercolNode/name[contains(@sel,$innercolsel)]">


          <xsl:variable name="cellclass">
             <xsl:if test="position()=1">firstcell</xsl:if>
          </xsl:variable>


           <!-- Aufruf der Ausgabefunktion mit den noch fehlenden Ausgabevariablen aus den innerrcolumns   -->
           <xsl:call-template name="colput">

                <xsl:with-param name="region"     select="$cregion  [$column='countries']   | following-sibling::key[1][$innercolumn='countries']   | $region  [$column!='countries' and $innercolumn!='countries' ]" />
                <xsl:with-param name="year"       select="$cyear    [$column='years']       | following-sibling::key[1][$innercolumn='years']       | $year    [$column!='years'     and $innercolumn!='years'     ]" />
                <xsl:with-param name="scenario"   select="$cscenario[$column='scenarios']   | following-sibling::key[1][$innercolumn='scenarios']   | $scenario[$column!='scenarios' and $innercolumn!='scenarios' ]" />
                <xsl:with-param name="product"    select="$cproduct [$column='products']    | following-sibling::key[1][$innercolumn='products']    | $product [$column!='products'  and $innercolumn!='products'  ]" />
                <xsl:with-param name="item"       select="$citem    [$column='items']       | following-sibling::key[1][$innercolumn='items']       | $item    [$column!='items'     and $innercolumn!='items'     ]" />
                <xsl:with-param name="cellclass"  select="$cellclass"/>

                <xsl:with-param name="mode"       select="$mode"/>
           </xsl:call-template>
       </xsl:for-each>
    </xsl:if>

    <!-- 2. Fall: keine inneren columns                                                                 -->
    <xsl:if test="$innercolumn=''">

       <xsl:variable name="cellclass">
          <xsl:if test="position()=1">firstcell</xsl:if>
       </xsl:variable>


       <!-- Aufruf der Ausgabefunktion mit den noch fehlenden Ausgabevariablen aus den innercolumns     -->
       <xsl:call-template name="colput">
           <xsl:with-param name="region"     select="$cregion  [$column='countries']    | $region  [$column!='countries'] "/>
           <xsl:with-param name="year"       select="$cyear    [$column='years']        | $year    [$column!='years'    ] "/>
           <xsl:with-param name="scenario"   select="$cscenario[$column='scenarios']    | $scenario[$column!='scenarios'] "/>
           <xsl:with-param name="product"    select="$cproduct [$column='products']     | $product [$column!='products' ] "/>
           <xsl:with-param name="item"       select="$citem    [$column='items']        | $item    [$column!='items'    ] "/>
           <xsl:with-param name="cellclass"  select="$cellclass"/>

           <xsl:with-param name="mode"       select="$mode"/>
           <xsl:with-param name="label"      select="."/>
           <xsl:with-param name="position"   select="position()"/>
       </xsl:call-template>
  </xsl:if>
  </xsl:for-each>

  </xsl:if>
</xsl:template>

<!-- ********************************************************************************************************* -->
<!--                                                                                                           -->
<!--        Funktion zur Ausgabe einzelner Spalten der Tabelle                                                 -->
<!--                                                                                                           -->
<!-- ********************************************************************************************************* -->

<xsl:template name="colput">

  <xsl:param name="region"/>
  <xsl:param name="year"/>
  <xsl:param name="product"/>
  <xsl:param name="scenario"/>
  <xsl:param name="item"/>
  <xsl:param name="cellclass"/>

  <xsl:param name="mode"/>
  <xsl:param name="label"/>
  <xsl:param name="position"/>

  <xsl:variable name="link"  select="$item/parent::item/link"/>
  <xsl:variable name="class" select="$item/parent::item/class"/>

  <!-- generieren der Variable datfile, in der Name der Datendatei steht                                -->
  <xsl:variable name="datfile" select="concat($region, $year, $scenario, '.xml')"/>


  <!-- generieren der Variable basedatfile, die die Bezugsdatei fr den proz. Vergleich definiert       -->
  <xsl:variable name="compscen" select="/report/scenarios/scenario[key = $scenario]/@comp"/>

  <!-- generieren der Variable basedatfile, die die Bezugsdatei fr den proz. Vergleich definiert       -->
  <xsl:variable name="basedatfile">
        <xsl:if test="$compscen!=''">
          <xsl:value-of  select="concat($region,$year,$compscen,'.xml')"/>
        </xsl:if>
        <xsl:if test="$compscen=''">
          <xsl:value-of  select="$datfile"/>
        </xsl:if>
  </xsl:variable>

  <xsl:variable name="aggregate">
         <xsl:if test="($activity)='no'">
            <xsl:value-of select="key('product',$product)/key[@aggreg='yes']"/>
         </xsl:if>
         <xsl:if test="($activity)='yes'">
            <xsl:value-of select="key('activity',$product)/key[@aggreg='yes']"/>
         </xsl:if>
  </xsl:variable>

  <xsl:variable name="aggregname">
         <xsl:if test="$activity='no'">
            <xsl:value-of select="key('product',$product)/name[@aggreg='yes']"/>
         </xsl:if>
         <xsl:if test="$activity='yes'">
            <xsl:value-of select="key('activity',$product)/name[@aggreg='yes']"/>
         </xsl:if>
  </xsl:variable>

  <!--

  <TD>COLPUT</TD>
  <TD>region     =  <xsl:value-of select="$region"/></TD>
  <TD>activity   ='<xsl:value-of select="$activity"/>'</TD>
  <TD>year       =  <xsl:value-of select="$year"/></TD>
  <TD>scenario   =  <xsl:value-of select="$scenario"/></TD>
  <TD>product    =  <xsl:value-of select="$product"/></TD>
  <TD>item       =  <xsl:value-of select="$item"/></TD>
  <TD>aggregate  =  <xsl:value-of select="$aggregate"/></TD>
  <TD>link       =  <xsl:value-of select="$link"/></TD>

  <TD>datfile    =  <xsl:value-of select="$datfile"/></TD>
  <TD>basdatfile =  <xsl:value-of select="$basedatfile"/></TD>
  -->

  <!-- Wechsel in die Datendatei                                                                        -->

  <xsl:for-each select="document(string($basedatfile))">

      <xsl:variable name="baseref">
         <xsl:if test="$activity='no'">
           <xsl:value-of select="key('Product',$product)/attribute::*[name()=$item]"/>
         </xsl:if>
         <xsl:if test="$activity='yes'">
             <xsl:value-of select="key('Product',$item)/attribute::*[name()=$product]"/>
         </xsl:if>
      </xsl:variable>

      <xsl:variable name="value">
         <xsl:if test="$datfile  = $basedatfile">
             <xsl:copy-of select="$baseref"/>
         </xsl:if>
         <xsl:if test="$datfile != $basedatfile">
             <xsl:for-each select="document(string($datfile))">
                <xsl:if test="$activity='no'">
                  <xsl:value-of select="key('Product',$product)/attribute::*[name()=$item]"/>
                </xsl:if>
                <xsl:if test="$activity='yes'">
                    <xsl:value-of select="key('Product',$item)/attribute::*[name()=$product]"/>
                </xsl:if>
             </xsl:for-each>
         </xsl:if>
      </xsl:variable>

      <xsl:if test="$mode='draw'">
              <xsl:if test="$value!=''">
                <xsl:value-of select="number($value)"/>
              </xsl:if>
              <xsl:if test="$value=''">
                <xsl:text>1.E-10</xsl:text>
              </xsl:if>
              <xsl:text>,</xsl:text>
      </xsl:if>


      <xsl:if test="$mode='text'">

         <td class="cell">
         <xsl:if test="$cellclass !=''"><xsl:attribute name="class"><xsl:value-of select="$cellclass"/></xsl:attribute></xsl:if>
         <xsl:if test="$class !=''">    <xsl:attribute name="class"><xsl:value-of select="$class"/>    </xsl:attribute></xsl:if>


         <xsl:choose>
             <xsl:when test="$value!=''">

                <xsl:choose>
                   <!-- verlinkt wird der Wert nur, wenn es sich um die Ausgabe eines Aggregates handelt           -->
                   <xsl:when test="$aggregate=$product and $link!='' and $setLinks='yes'" >

                       <a class="link">
                        <xsl:attribute name="href"><xsl:text></xsl:text><xsl:value-of select="$link"/>
                        </xsl:attribute>

                        <xsl:attribute name="onClick">

                          <xsl:text>call_parser("</xsl:text>
                          <xsl:value-of select="$region"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$year"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$scenario"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$product"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$item"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$link"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$comparison"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$mode"/>
                          <xsl:text>","</xsl:text><xsl:value-of select="$xmlfile"/>
                          <xsl:text>","TOP")</xsl:text>
                        </xsl:attribute>


                        <xsl:call-template name="breaks">
                              <xsl:with-param name="value" select="$value"/>
                        </xsl:call-template>

                        </a>

                   </xsl:when>
                   <!-- Ausgabe des Wertes ohne link                                                               -->
                   <xsl:otherwise>
                        <xsl:call-template name="breaks">
                              <xsl:with-param name="value" select="$value"/>
                        </xsl:call-template>
                   </xsl:otherwise>
                </xsl:choose>

                                             <!-- falls nicht aus dem basedatfile gelesen wurde wird nun die Bezugsgre gelesen und           -->
                                             <!-- prozentual vergliche -->
                <xsl:if test="($datfile != $basedatfile) and $baseref!=''">


                     <xsl:if test="$comparison = 'percent'">
                        <xsl:variable name="percent" select="($value - $baseref) div $baseref"/>
                        <xsl:if test="string($percent)!='NaN'">
                           <br/><span class="percent"><xsl:value-of select="format-number($percent, '##0.00%')" /></span>
                        </xsl:if>
                     </xsl:if>

                     <xsl:if test="$comparison = 'difference'">
                        <xsl:variable name="percent" select="($value - $baseref) div $baseref"/>
                        <xsl:if test="string($percent)!='NaN'">
                           <br/><span class="percent"><xsl:value-of select="format-number($value - $baseref, '##0.00')" /></span>
                        </xsl:if>
                     </xsl:if>

                </xsl:if>
             </xsl:when>
             <!-- falls es keinen Wert gab, wird ein Leerzeichen geschrieben (fr die html-Tabelle &nbsp)        -->
             <xsl:otherwise>
                &#160;
             </xsl:otherwise>
         </xsl:choose>
         </td>
      </xsl:if>
  </xsl:for-each>

</xsl:template>                                                           <!-- Ende von template colput -->

<!-- ********************************************************************************************************* -->
<!--                                                                                                           -->
<!--        Funktion zur Ausgabe der einzelnen Zellen, eventuell mit Breaks (dann rekursiv)                    -->
<!--                                                                                                           -->
<!-- ********************************************************************************************************* -->

<xsl:template name="breaks">

  <xsl:param name="value"/>

  <xsl:variable name="before" select="substring-before($value,' _ ')"/>
  <xsl:variable name="after"  select="substring-after($value,' _ ')"/>

  <xsl:if test="string-length($before)=0 and string-length($after)=0 and $value!=' _ '"><xsl:value-of select="$value"/></xsl:if>

  <xsl:if test="string-length($before)!=0"><xsl:value-of select="$before"/></xsl:if>


  <xsl:if test="$after!=''">
     <br/>
     <xsl:call-template name="breaks">
           <xsl:with-param name="value" select="$after"/>
     </xsl:call-template>
  </xsl:if>

</xsl:template>

<!-- ********************************************************************************************************* -->
<!--                                                                                                           -->
<!--        Funktion zur des compare scenarios                                                                 -->
<!--                                                                                                           -->
<!-- ********************************************************************************************************* -->



<xsl:template name="compscen">

  <xsl:param name="scenario"/>

  <xsl:if test="$scenario!=''">

     <xsl:variable name="comp" select="/report/scenarios/scenario[name = $scenario]/@comp"/>
     <xsl:if test="$comp!=''">
         <xsl:variable name="compscen" select="/report/scenarios/scenario[key = $comp]/name"/>

         <span class="percent">
         <xsl:if test="$comparison = 'difference'">
            <BR/>difference to : <xsl:value-of select="$compscen"/>
         </xsl:if>
         <xsl:if test="$comparison = 'percent'">
            <BR/>percent deviation to : <xsl:value-of select="$compscen"/>
         </xsl:if>
         </span>
     </xsl:if>
  </xsl:if>

</xsl:template>

<!-- ********************************************************************************************************* -->
<!--                                                                                                           -->
<!--        Funktion zur Ausgabe der Header Zeilen                                                             -->
<!--                                                                                                           -->
<!-- ********************************************************************************************************* -->

<xsl:template name="header">

  <xsl:param name="region"/>
  <xsl:param name="year"/>
  <xsl:param name="anchor"/>
  <xsl:param name="mode"/>

  <!--
  <TD>colNode   =  <xsl:value-of select="$colNode"/></TD>
  <TD>innercolNode =  <xsl:value-of select="$innercolNode"/></TD>
  <TD>innerow  =  <xsl:value-of select="$innerrow"/></TD>
  <TD>region    =  <xsl:value-of select="$region"/></TD>
  <TD>year      =  <xsl:value-of select="$year"/></TD>
  -->

  <!-- Ueberschriften -->

  <tr>

    <td class="corner">

       <xsl:if test="$mode='text'">
             <xsl:attribute name="width">30%</xsl:attribute>

          <xsl:if test="$innerrow!=''">
                <xsl:attribute name="colspan">2</xsl:attribute>
          </xsl:if>
          <xsl:if test="$innercolumn!=''">
                <xsl:attribute name="rowspan">2</xsl:attribute>
          </xsl:if>
       </xsl:if>

       <a><xsl:attribute name="name"><xsl:value-of select="$anchor"/></xsl:attribute></a>
         <xsl:if test="$column!='countries' and $innercolumn!='countries' and $row!='countries' and $innerrow!='countries'">
             Region : <xsl:value-of select="key('region',  $regionNode)/name"/>
         </xsl:if>
         <xsl:if test="$column!='years' and $innercolumn!='years' and $row!='years' and $innerrow!='years' and $year!=''">
            <BR/>Year : <xsl:value-of select="key('year', $yearNode)/name"/>
         </xsl:if>
         <xsl:if test="$column!='scenarios' and $innercolumn!='scenarios' and $row!='scenarios' and $innerrow!='scenarios'">
            <BR/>Scenario : <xsl:value-of select="key('scenario',$scenarioNode)/name"/>

           <xsl:call-template name="compscen">
                <xsl:with-param name="scenario"     select="key('scenario',$scenarioNode)/name" />
           </xsl:call-template>

         </xsl:if>
         <xsl:if test="$column!='products' and $innercolumn!='products' and $row!='products' and $innerrow!='products'">

            <xsl:if test="$activity='no'">
               <BR/>Product  : <xsl:value-of select="key('product', $productNode)/name"/>
            </xsl:if>
            <xsl:if test="$activity='yes'">
               <BR/>Activity : <xsl:value-of select="key('activity', $productNode)/name"/>
            </xsl:if>
         </xsl:if>
         <xsl:if test="$column!='items' and $innercolumn!='items' and $row!='items' and $innerrow!='items'">
         <BR/>Item : <xsl:value-of select="key('item',    $itemNode)/name"/>
             <BR/>       (<xsl:value-of select="key('item',    $itemNode)/unit"/>)
         </xsl:if>
       </td>


       <xsl:if test="$mode='text'">
          <xsl:for-each select="$colNode/name[contains(@sel,$colsel)]">


              <td class="columnname">
                 <xsl:if test="$innercolNode">
                     <xsl:attribute name="colspan"><xsl:value-of select="$innercolnum"/></xsl:attribute>
                 </xsl:if>

                 <xsl:attribute name="width">
                    <xsl:choose>
                    <xsl:when test="following-sibling::width[1]!=''"><xsl:value-of select="following-sibling::width[1]"/></xsl:when>
                    <xsl:otherwise>                                  <xsl:value-of select="$colWidth"/></xsl:otherwise>
                    </xsl:choose>
                 </xsl:attribute>

                 <xsl:value-of select="."/>

                 <xsl:variable name="cunit"      select="following-sibling::unit[1][$column='items'] "/>
                 <xsl:if test="$cunit!=''"><BR/><span class="unit"><xsl:value-of select="$cunit" /></span></xsl:if>

                 <xsl:if test="current()[@aggreg = 'yes']">
                   <a><xsl:attribute name="name"><xsl:value-of select="."/></xsl:attribute></a>
                 </xsl:if>

                 <xsl:if test="$column='scenarios'">
                    <xsl:call-template name="compscen">
                       <xsl:with-param name="scenario"  select="."/>
                    </xsl:call-template>
                 </xsl:if>
            </td>
          </xsl:for-each>
       </xsl:if>
     </tr>

     <xsl:if test="$mode='text'">
        <xsl:if test="$innercolNode">
          <tr>

            <xsl:for-each select="$colNode/name[contains(@sel,$colsel)]">
            <xsl:for-each select="$innercolNode/name[contains(@sel,$innercolsel)]">

                <td class="innercolumnname">
                  <xsl:if test="position()=1"><xsl:attribute name="class">firstinnercol</xsl:attribute></xsl:if>

                  <xsl:attribute name="width">
                     <xsl:choose>
                     <xsl:when test="following-sibling::width[1]!=''"><xsl:value-of select="following-sibling::width[1]"/></xsl:when>
                     <xsl:otherwise>                                  <xsl:value-of select="$innercolWidth"/></xsl:otherwise>
                     </xsl:choose>
                  </xsl:attribute>

                  <xsl:value-of select="."/>

                  <xsl:variable name="cunit"      select="following-sibling::unit[1][$innercolumn='items'] "/>
                  <xsl:if test="$cunit!=''"><BR/><span class="unit"><xsl:value-of select="$cunit" /></span></xsl:if>

                  <xsl:if test="$column='scenarios'">
                     <xsl:call-template name="compscen">
                        <xsl:with-param name="scenario"  select="."/>
                     </xsl:call-template>
                 </xsl:if>

                </td>
              </xsl:for-each>

            </xsl:for-each>
          </tr>
        </xsl:if>
     </xsl:if>
</xsl:template>

</xsl:stylesheet>                                      <!-- Ende des stylesheets -->


